# Welcome to Sidekiq 5.0!

Sidekiq 5.0 contains a reworked job dispatch and execution core to integrate
better with the new Rails 5.0 Executor.  It also drops support for older
versions of Ruby and Rails and adds support for RTL languages in the Web UI.

## What's New

* Integrate job logging and retry logic directly in with the job
  execution logic in Sidekiq::Processor.  Previously this logic was
  defined as middleware.  In Rails 5.0, ActiveSupport::Executor handles ActiveRecord
  connection management, job callbacks, development mode class loading,
  etc.  Because of its extensive responsibilities, the Executor can't be
  integrated as Sidekiq middleware; the logging/retry logic had to be pulled out
  too.  Sidekiq 4.2 had a hack to make it work but this redesign provides
  a cleaner integration. [#3235]
* The Delayed Extensions `delay`, `delay_in` and `delay_until` APIs are
  no longer available by default.  The extensions allow you to marshal
  job arguments as YAML, leading to cases where job payloads could be many
  100s of KB or larger if not careful, leading to Redis networking
  timeouts or other problems.  As noted in the Best Practices wiki page,
  Sidekiq is designed for jobs with small, simple arguments.

  Add this line to your initializer to re-enable them and get the old behavior:
  ```ruby
  Sidekiq::Extensions.enable_delay!
  ```
  The old `Sidekiq.remove_delay!` API has been removed as it is now the default. [#3299]
* Sidekiq's quiet signal is now `TSTP` (think of it as **T**hread
  **ST**o**P**) instead of USR1 as USR1 is not available on JRuby.
  USR1 will continue to be supported in Sidekiq 5.x for backwards
  compatibility and will be removed in Sidekiq 6.x. [#3302]
* The Web UI is now bi-directional - it can render either LTR
  (left-to-right) or RTL languages. With this change, **Farsi, Arabic,
  Hebrew and Urdu** are officially supported. [#3381]
* Jobs which can't be parsed due to invalid JSON are now pushed
  immediately to the Dead set since they require manual intervention and
  will never execute successfully as is.  The Web UI has been updated to
  more gracefully display these jobs. [#3296]
* **Rails 3.2** is no longer supported.
* **Ruby 2.0 and Ruby 2.1** are no longer supported. Ruby 2.2.2+ is required.

## Upgrade

As always, please upgrade Sidekiq **one major version at a time**.
If you are already running Sidekiq 4.x, then:

* Upgrade to the latest Sidekiq 4.x.
```ruby
gem 'sidekiq', '< 5'
```
* Fix any deprecation warnings you see.
* Upgrade to 5.x.
```ruby
gem 'sidekiq', '< 6'
```
